﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EIS
{
    /// <summary>
    /// The hosptial location writer.
    /// </summary>
    class HospitalLocationWriter : BaseEisWriter<HospitalLocation, FC.HospitalLocation>
    {
        public override void InitCache()
        {
            Data.SetCacheForHospitalLocation();
        }

        private string wardLocationId;
        protected override FC.HospitalLocation GetBmsEntity(HospitalLocation entity)
        {
            wardLocationId = (entity.WardLocation != null && !string.IsNullOrEmpty(entity.WardLocationId)) ? InsertIfNullOrUpdateIfDirty<WardLocation, FC.Ward>(entity.WardLocation).Id.extension : null;
            return base.GetBmsEntity(entity);
        }

        /// <summary>
        /// Adds the modifications for BMS entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void TranslateFromVistaToBMS(HospitalLocation entity, FC.HospitalLocation bmsEntity)
        {
            bmsEntity.Ien = entity.IEN;
            bmsEntity.Name = entity.Name;
            bmsEntity.VistaSite = VistaSite;
            bmsEntity.Abbrevation = entity.Abbreviation;
            bmsEntity.Telephone = entity.Telephone;
            bmsEntity.WardLocationId = wardLocationId;
        }


        protected override bool AreFieldsEqual(HospitalLocation entity, FC.HospitalLocation bmsEntity)
        {
            bool result = ((string.IsNullOrEmpty(entity.Abbreviation) && string.IsNullOrEmpty(bmsEntity.Abbrevation)) || (entity.Abbreviation == bmsEntity.Abbrevation)) &&
                          entity.Name == bmsEntity.Name &&
                          CompareStrings(entity.Telephone, bmsEntity.Telephone) &&
                          CompareStrings(wardLocationId, bmsEntity.WardLocationId);
            return result;
        }

        private bool CompareStrings(string str1, string str2)
        {
            if (string.IsNullOrEmpty(str1) && string.IsNullOrEmpty(str2)) return true;
            if (!string.IsNullOrEmpty(str1) && string.IsNullOrEmpty(str2)) return false;
            if (string.IsNullOrEmpty(str1) && !string.IsNullOrEmpty(str2)) return false;
            if (str1.Equals(str2, StringComparison.InvariantCultureIgnoreCase)) return true;
            return false;
        }

        protected override IEntityDal<FC.HospitalLocation> Dal
        {
            get { return Data.HospitalLocationDal; }
        }
    }
}
